define(['angular', 'angularMocks', 'CustomMessagesController', 'angularUiBootstrap', 'lodash'], function (angular, mocks) {
	'use strict';

	describe('The Custom Messages controller', function () {
		var controller,
			scope,
			state,
			q,
			modalServiceMock,
			focusServiceMock,
			connectionErrorServiceMock,
			customMessagesServiceMock,
			validationSummaryMock,
			activeInstitutionMock;

		beforeEach(function () {
			module('angularTemplateApp');

			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain','focusPrimary']);
			connectionErrorServiceMock = jasmine.createSpyObj('connectionErrorService', ['showServerErrorMsg']);
			customMessagesServiceMock = jasmine.createSpyObj('CustomMessagesService', ['fetch', 'save', 'getFacility', 'fetchDefault']);
			validationSummaryMock = jasmine.createSpyObj('validationSummary', ['validate', 'clear', 'summarizeAsync']);
			activeInstitutionMock = {
				childName: 'mock'
			};


			module(function($provide){
				$provide.value('modalService', modalServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('connectionErrorService', connectionErrorServiceMock);
				$provide.value('CustomMessagesService', customMessagesServiceMock);
				$provide.value('activeInstitution', activeInstitutionMock);
			});

			inject(function($controller, $rootScope, $q){
				scope = $rootScope.$new();

				modalServiceMock.showModal.andCallFake( function() {
					return {
						then: function(callback) { return callback(); }
					};
				} );

				customMessagesServiceMock.fetch.andCallFake( function() {
					var promise = $q.defer();
					var response ={
						status: 200,
						data: [{
					messageId:'appointmentNoPreferredDatePopup',
					maxLength:250,
					page:"New Appointment/Request",
					field:"Select Date/Time – Don’t see a date or time that works for you (Pop-Up Content)"
				},
				{
					messageId:'noClinicRadioButtons',
					maxLength:250,
					page:"New Appointment/Request",
					field:"DropDown"
				}
						]};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				customMessagesServiceMock.save.andCallFake( function(data) {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: data
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				validationSummaryMock.validate.andCallFake( function(){
					return {
						then: function(callback) { return callback(); }
					};
				} );


				controller = $controller('CustomMessagesController', {$scope: scope} );

				scope.customMessagesForm = {
					validationSummary: validationSummaryMock,
					$setPristine: function (){},
					$setSubmitted: function (){}
				};
			});
		});

		it('should save the form data', function(){
			scope.customMessages = {
				userFriendlyText: "Clinic Home",
				customMessages: [
					{
						messageId:'appointmentNoPreferredDatePopup',
						maxLength:250,
						page:"New Appointment/Request",
						field:"Select Date/Time – Don’t see a date or time that works for you (Pop-Up Content)"
					},
					{
						messageId:'noClinicRadioButtons',
						maxLength:250,
						page:"New Appointment/Request",
						field:"No Clinic Radio"
					}
				]
		};
			scope.save();
			expect(customMessagesServiceMock.save).toHaveBeenCalledWith(scope.customMessages,activeInstitutionMock.childName);
			expect(modalServiceMock.showModal).toHaveBeenCalled();
			expect(validationSummaryMock.summarizeAsync).toHaveBeenCalled();
			expect(scope.customMessages.userFriendlyText).toEqual('Clinic Home');
			expect(scope.customMessages.customMessages[0].field).toEqual('Select Date/Time – Don’t see a date or time that works for you (Pop-Up Content)');

			expect(scope.customMessages.customMessages[1].field).toEqual('Type of Care');
			expect(scope.customMessages.customMessages[2].field).toEqual('No Clinic Radio');

		});


	});
});
